<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function payments()
    {
        return $this->hasMany('Payment');
    }

    public function invoiceDetails()
    {
        return $this->hasMany('InvoiceDetail');
    }

}